<!--sidebar end-->
<!--main content start-->
<section id="main-content">
    <section class="wrapper site-min-height">
        <!-- page start-->
        <div class="col-md-12">
            <section class="panel">
                <header class="panel-heading">
                    <i class="fas fa-stream"></i> <?= lang('product_sale_list'); ?>
                </header>
                <div class="panel-body">
                    <div class="adv-table editable-table">
                        <div class="clearfix">
                            <a data-toggle="modal" href="<?php echo base_url('sale/addNewProductSale') ?>">
                                <div class="btn-group">
                                    <button id="" class="button button-primary">
                                        <i class="fas fa-plus-circle"></i> <?= lang('add_new_product_sale'); ?>
                                    </button>
                                </div>
                            </a>
                            <a href="<?php echo base_url('product/listProduct'); ?>">
                                <div class="btn-group">
                                    <button class="button button-info">
                                        <i class="fa-solid fa-circle-arrow-up"></i> <?= lang('production'); ?> <?= lang('list'); ?>
                                    </button>
                                </div>
                            </a>
                            <button class="export" onclick="javascript:window.print();"><i class="fa-solid fa-print"></i> <?php echo lang('print'); ?></button>
                        </div>
                        <div class="space15"></div>
                        <table class="table table-striped table-hover table-bordered" id="editable-sample">
                            <thead>
                                <tr>
                                    <th><?= lang('serialNo'); ?>.</th>
                                    <th><?= lang('sale_date'); ?></th>
                                    <th><?= lang('client'); ?></th>
                                    <th><?= lang('total_sold_amount'); ?></th>
                                    <th><?php echo lang('options'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $serial = 0;
                                foreach ($productsSale as $key => $list) {
                                    $serial++;
                                ?>
                                    <tr>
                                        <td><?= $serial ?></td>
                                        <td><?= date("$settings->date_format", strtotime($list->prss_date)) ?></td>
                                        <td><?= $this->client_model->getClientById($list->prss_c_id)->c_name; ?></td>
                                        <td><?= $settings->currency . number_format($list->prss_grand_total, 2, '.', ','); ?></td>
                                        <td>
                                            <a class="button button-success" href="<?php echo base_url('') ?>sale/viewProductSale?prss_id=<?php echo $list->prss_id; ?>"><i class="fas fa-eye"></i> <?= lang('view'); ?></a>
                                            <a class="button button-primary" href="<?php echo base_url('') ?>sale/viewProductSaleClientInvoice?prss_id=<?php echo $list->prss_id; ?>"><i class="fa fa-file"></i> <?= lang('invoice_capital'); ?></a>
                                            <a class="button button-warning" href="<?php echo base_url('') ?>sale/editProductSale?prss_id=<?php echo $list->prss_id; ?>"><i class="fas fa-edit"></i> <?php echo lang('edit'); ?></a>
                                            <a class="button button-danger" href="<?php echo base_url('') ?>sale/deleteProductSale?prss_id=<?php echo $list->prss_id; ?>" onclick="return confirm('<?= lang('are_you_sure_want_to_delete_this_item'); ?>')"><i class="fas fa-trash"></i> <?php echo lang('delete'); ?></a>
                                        </td>
                                    </tr>
                                <?php } ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </section>
        </div>
        <!-- page end-->
    </section>
</section>
<!--main content end-->