<!--sidebar end-->
<!--main content start-->
<section id="main-content">
    <section class="wrapper site-min-height">
        <!-- page start-->
        <div class="col-md-12">
            <section class="panel">
                <header class="panel-heading">
                    <i class="fas fa-stream"></i> <?php echo lang('supplier'); ?>
                </header>
                <div class="panel-body">
                    <div class="adv-table editable-table ">
                        <div class="clearfix">
                            <a data-toggle="modal" href="#myModal">
                                <div class="btn-group">
                                    <button id="" class="button button-primary">
                                        <i class="fa fa-plus-circle"></i> <?php echo lang('add_new_supplier'); ?>
                                    </button>
                                </div>
                            </a>
                            <button class="export" onclick="javascript:window.print();"><i class="fa-solid fa-print"></i> <?php echo lang('print'); ?></button>
                        </div>
                        <div class="space15"></div>
                        <table class="table table-striped table-hover table-bordered" id="editable-sample">
                            <thead>
                                <tr>
                                    <th><?= lang('serialNo'); ?></th>
                                    <th><?= lang('image'); ?></th>
                                    <th><?= lang('name'); ?></th>
                                    <th><?= lang('email'); ?></th>
                                    <th><?= lang('phone'); ?></th>
                                    <th><?= lang('address'); ?></th>
                                    <th><?= lang('options'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $serial = 0;
                                foreach ($suppliers->result() as $supplier) {
                                    $serial++;
                                ?>
                                    <tr>
                                        <td><?= $serial ?></td>
                                        <td>
                                            <?php if ($supplier->s_img_url) { ?>
                                                <img class="img-circle" style="height: 50px; width: 50px;" src="<?php echo $supplier->s_img_url; ?>" alt="No img">
                                            <?php } else { ?>
                                                <img class="img-circle" style="height: 50px; width: 50px;" src="<?php echo base_url('uploads/avatar/alter-image.png'); ?>" alt="No img">
                                            <?php } ?>
                                        </td>
                                        <td> <?= $supplier->s_name; ?></td>
                                        <td><?= $supplier->s_email; ?></td>
                                        <td><?= $supplier->s_phone; ?></td>
                                        <td><?= $supplier->s_address; ?></td>
                                        <td>
                                            <?php
                                            $countDataIfAvailableInLivestockPurchase = $this->settings_model->getCountRow('livestock_purchase_summary', 'purs_id', ['purs_supp_id' => $supplier->s_id, 'purs_status' => 1]);
                                            $countDataIfAvailableInFoodPurchase = $this->settings_model->getCountRow('food_purchase_summary', 'fdps_id', ['fdps_s_id' => $supplier->s_id, 'fdps_status' => 1]);
                                            $countDataIfAvailableInVaccinePurchase = $this->settings_model->getCountRow('vaccine_purchase_summary', 'vps_id', ['vps_s_id' => $supplier->s_id, 'vps_status' => 1]);
                                            ?>
                                            <button type="button" class="button button-warning editButton" data-toggle="modal" data-id="<?= $supplier->s_id; ?>"><i class="fas fa-edit"></i> <?php echo lang('edit'); ?></button>
                                            <a href="<?php echo base_url(''); ?>supplier/deleteSupplier?s_id=<?= $supplier->s_id; ?>" onclick="return confirm('<?= lang('are_you_sure_want_to_delete_this_item'); ?>');"><button <?php echo ($countDataIfAvailableInLivestockPurchase == 0 && $countDataIfAvailableInFoodPurchase == 0 && $countDataIfAvailableInVaccinePurchase == 0) ? true : "disabled"; ?> type="button" class="button button-danger"><i class="fas fa-trash"></i> <?php echo lang('delete'); ?></button></i></a>
                                            <a href="<?php echo base_url(''); ?>payments/viewSupplierWisePayment?id=<?= $supplier->s_id; ?>"><button type="button" class="button button-info"><i class="fas fa-eye"></i> <?= lang('ledger'); ?> </button></i></a>
                                        </td>
                                    </tr>
                                <?php } ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </section>
        </div>
        <!-- page end-->
    </section>
</section>
<!--main content end-->


<!--footer start-->
<div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-info">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                <h4 class="modal-title"><strong><i class="fa fa-plus-circle"></i> <?php echo lang('add_new_supplier'); ?></strong></h4>
            </div>
            <div class="modal-body" style="height:100%;">
                <form role="form" action="<?php echo base_url('supplier/insertSupplier'); ?>" method="post" enctype="multipart/form-data">
                    <div class="form-group">
                        <label for="exampleInputEmail1"><?php echo lang('name'); ?><span class="text-danger">*</span></label>
                        <input type="text" class="form-control" name="s_name" id="" value='' required>
                    </div>
                    <div class="form-group">
                        <label for="exampleInputEmail1"><?php echo lang('email'); ?></label>
                        <input type="text" class="form-control" name="s_email" id="" value=''>
                    </div>
                    <div class="form-group">
                        <label for="exampleInputEmail1"><?php echo lang('phone'); ?><span class="text-danger">*</span></label>
                        <input type="text" class="form-control" name="s_phone" id="" value='' required>
                    </div>
                    <div class="form-group">
                        <label for="exampleInputEmail1"><?php echo lang('address'); ?><span class="text-danger">*</span></label>
                        <input type="text" class="form-control" name="s_address" id="" value='' required>
                    </div>
                    <div class="form-group">
                        <label for="exampleInputEmail1"><?php echo lang('description'); ?></label>
                        <textarea name="s_description" class="form-control" id="" rows="5" placeholder="Enter Description" style="height: auto !important;"></textarea>
                    </div>
                    <div class="form-group">
                        <label for="exampleInputEmail1"><?php echo lang('image'); ?></label>
                        <input type="file" name="s_img_url">
                    </div>

                    <input type="hidden" name="id" value=''>
                    <input type="hidden" name="s_id" value=''>

                    <section class="">
                        <button type="submit" name="submit" class="button button-info submit_button"><?php echo lang('submit'); ?></button>
                    </section>
                </form>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div>
<!-- Edit Client -->
<div class="modal fade" id="myModal2" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" style="display: none;">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-info">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                <h4 class="modal-title"><strong><i class="fa fa-edit"></i> <?php echo lang('edit_supplier'); ?></strong></h4>
            </div>
            <div class="modal-body" style="height:100%;">
                <form role="form" id="supplierEditForm" action="<?php echo base_url('supplier/insertSupplier'); ?>" method="post" enctype="multipart/form-data">
                    <div class="form-group">
                        <label for="exampleInputEmail1"><?php echo lang('name'); ?><span class="text-danger">*</span></label>
                        <input type="text" class="form-control" name="s_name" id="" value='' required>
                    </div>
                    <div class="form-group">
                        <label for="exampleInputEmail1"><?php echo lang('email'); ?></label>
                        <input type="email" class="form-control" name="s_email" id="" value=''>
                    </div>

                    <div class="form-group">
                        <label for="exampleInputEmail1"><?php echo lang('phone'); ?><span class="text-danger">*</span></label>
                        <input type="text" class="form-control" name="s_phone" id="" value='' required>
                    </div>
                    <div class="form-group">
                        <label for="exampleInputEmail1"><?php echo lang('address'); ?><span class="text-danger">*</span></label>
                        <input type="text" class="form-control" name="s_address" id="" value='' required>
                    </div>
                    <div class="form-group">
                        <label for="exampleInputEmail1"><?php echo lang('description'); ?></label>
                        <textarea name="s_description" class="form-control" id="" rows="5" placeholder="Enter Description" style="height: auto !important;"></textarea>
                    </div>

                    <div class="form-group">
                        <label for="exampleInputEmail1"><?php echo lang('image'); ?></label>
                        <input type="file" name="s_img_url">
                    </div>
                    <input type="hidden" name="s_id" value=''>
                    <section class="">
                        <button type="submit" name="submit" class="button button-info submit_button"><?php echo lang('edit_button'); ?></button>
                    </section>
                </form>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div>


<!-- Javascript For Edit Supplier -->
<script src="<?php echo base_url('common/js/jquery-1.11.1.min.js'); ?>"></script>
<script type="text/javascript">
    $(document).ready(function() {
        $(".editButton").click(function(e) {
            e.preventDefault(e);
            // Get the record's ID via attribute  
            var iid = $(this).attr('data-id');
            $.ajax({
                url: 'supplier/editSupplierByJason?s_id=' + iid,
                method: 'GET',
                data: '',
                dataType: 'json',
            }).success(function(response) {
                // Populate the form fields with the data returned from server
                $('#supplierEditForm').find('[name="s_id"]').val(response.suppliers.s_id).end()
                $('#supplierEditForm').find('[name="s_name"]').val(response.suppliers.s_name).end()
                $('#supplierEditForm').find('[name="s_email"]').val(response.suppliers.s_email).end()
                $('#supplierEditForm').find('[name="s_phone"]').val(response.suppliers.s_phone).end()
                $('#supplierEditForm').find('[name="s_address"]').val(response.suppliers.s_address).end()
                $('#supplierEditForm').find('[name="s_description"]').val(response.suppliers.s_description).end()
                $('#myModal2').modal('show');
            });

        });
    });
</script>