<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Settings_model extends CI_model
{

    function __construct()
    {
        parent::__construct();
        $this->load->database();
    }

    function getSettings()
    {
        $query = $this->db->get('settings');
        return $query->row();
    }

    function updateSettings($id, $data)
    {
        $this->db->where('id', $id);
        $this->db->update('settings', $data);
    }

    function getCountRow($table, $column, $condition)
    {
        $this->db->where($condition);
        $this->db->select("COUNT($column) AS total");
        $query = $this->db->count_all_results($table);
        return $query;
    }

    function getData($table, $data)
    {
        $this->db->where($data);
        $query = $this->db->get($table);
        return $query;
    }

    function getSingleData($table, $condition)
    {
        $this->db->where($condition);
        $query = $this->db->get($table);
        if ($this->db->affected_rows() > 0) {
            return $query->row();
        } else {
            return false;
        }
    }


    /* ============================================== Product Unit ==================================================== */
    // Insert Data
    public function insertData($table, $data)
    {
        $this->db->insert($table, $data);
        $returnValue = $this->db->insert_id();
        return $returnValue;
    }

    // Update Data
    public function updateData($table, $index, $identifier, $data)
    {
        $this->db->where($index, $identifier);
        $this->db->update($table, $data);
        if ($this->db->affected_rows() > 0) {
            return true;
        } else {
            return false;
        }
    }
    // Get Data
    function getUnit()
    {
        $this->db->where('un_status', 1);
        $query = $this->db->get('unit');
        return $query;
    }
    // Get Data By Id
    function getUnitById($ct_id)
    {
        // $this->db->where('un_status', 1);
        $this->db->where('un_id', $ct_id);
        $query = $this->db->get('unit');
        return $query->row();
    }
}
