<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Payments_model extends CI_model
{

    function __construct()
    {
        parent::__construct();
        $this->load->database();
    }

    public function insertData($table, $data)
    {
        $this->db->insert($table, $data);
        $returnValue = $this->db->insert_id();
        return $returnValue;
    }


    public function updateData($table, $index, $identifier, $data)
    {
        $this->db->where($index, $identifier);
        $this->db->update($table, $data);
        if ($this->db->affected_rows() > 0) {
            return true;
        } else {
            return false;
        }
    }

    function getSupplierPaymentsByPurchaseId($purchaseId)
    {
        $this->db->where('sp_status', 1);
        $this->db->where('sp_purs_id', $purchaseId);
        $query = $this->db->get('supplier_payment');
        return $query->result();
    }

    function getFoodSupplierPaymentsByPurchaseId($foodPurchaseId)
    {
        $this->db->where('sp_status', 1);
        $this->db->where('sp_fdps_id', $foodPurchaseId);
        $query = $this->db->get('supplier_payment');
        return $query->result();
    }

    function getVaccineSupplierPaymentsByPurchaseId($vaccinePurchaseId)
    {
        $this->db->where('sp_status', 1);
        $this->db->where('sp_vps_id', $vaccinePurchaseId);
        $query = $this->db->get('supplier_payment');
        return $query->result();
    }

    function getSupplierWiseSupplierPayments($supplier_id)
    {
        $this->db->where('sp_status', 1);
        $this->db->where('sp_s_id', $supplier_id);
        $query = $this->db->get('supplier_payment');
        return $query->result();
    }
    // Livestock purchase payment amount
    function getSumSupplierAndPurchaseWiseTotalPaidAmount($supplierId, $purchaseId)
    {
        $this->db->select('SUM(sp_payment_amount) AS total');
        $this->db->where('sp_s_id', $supplierId);
        $this->db->where('sp_purs_id', $purchaseId);
        $this->db->where('sp_status', 1);
        $query = $this->db->get('supplier_payment');
        return $query->row()->total;
    }
    // Food Purchase Payment Amourn
    function getSumSupplierAndFoodPurchaseWiseTotalPaidAmount($supplierId, $foodPurchaseId)
    {
        $this->db->select('SUM(sp_payment_amount) AS total');
        $this->db->where('sp_s_id', $supplierId);
        $this->db->where('sp_fdps_id', $foodPurchaseId);
        $this->db->where('sp_status', 1);
        $query = $this->db->get('supplier_payment');
        return $query->row()->total;
    }

    // Vaccine Purchase Payment Amourn
    function getSumSupplierAndVaccinePurchaseWiseTotalPaidAmount($supplierId, $vaccinePurchaseId)
    {
        $this->db->select('SUM(sp_payment_amount) AS total');
        $this->db->where('sp_s_id', $supplierId);
        $this->db->where('sp_vps_id', $vaccinePurchaseId);
        $this->db->where('sp_status', 1);
        $query = $this->db->get('supplier_payment');
        return $query->row()->total;
    }

    function getSumSupplierWiseTotalPaidAmount($supplierId)
    {
        $this->db->select('SUM(sp_payment_amount) AS total');
        $this->db->where('sp_s_id', $supplierId);
        $this->db->where('sp_status', 1);
        $query = $this->db->get('supplier_payment');
        return $query->row()->total;
    }
    // Payment Count Livestock Purchase 
    function getSupplierPurchaseWisePaymentCountRow($supplierId, $purs_id)
    {
        $count = $this->db->query("SELECT COUNT(sp_payment_amount) AS total FROM supplier_payment WHERE sp_s_id = '$supplierId' AND sp_purs_id = '$purs_id' AND sp_status = 1");
        return $count->row()->total;
    }
    // Payment Count Food Purchase 
    function getSupplierFoodPurchaseWisePaymentCountRow($supplierId, $fdps_id)
    {
        $count = $this->db->query("SELECT COUNT(sp_payment_amount) AS total FROM supplier_payment WHERE sp_s_id = '$supplierId' AND sp_fdps_id = '$fdps_id' AND sp_status = 1");
        return $count->row()->total;
    }

    // Payment Count Vaccine Purchase 
    function getSupplierVaccinePurchaseWisePaymentCountRow($supplierId, $vps_id)
    {
        $count = $this->db->query("SELECT COUNT(sp_payment_amount) AS total FROM supplier_payment WHERE sp_s_id = '$supplierId' AND sp_vps_id = '$vps_id' AND sp_status = 1");
        return $count->row()->total;
    }

    function getSumSupplierTotalPaidAmount()
    {
        $this->db->select('SUM(sp_payment_amount) AS total');
        $this->db->where('sp_status', 1);
        $query = $this->db->get('supplier_payment');
        return $query->row()->total;
    }




    /* =========================== Client Part =========================== */

    function getClientPaymentsBySaleId($saleId)
    {
        $this->db->where('cp_status', 1);
        $this->db->where('cp_lsss_id', $saleId);
        $query = $this->db->get('client_payment');
        return $query->result();
    }

    function getClientProductPaymentsBySaleId($saleId)
    {
        $this->db->where('cp_status', 1);
        $this->db->where('cp_prss_id', $saleId);
        $query = $this->db->get('client_payment');
        return $query->result();
    }

    function getClientWiseClientPayments($client_id)
    {
        $this->db->where('cp_status', 1);
        $this->db->where('cp_c_id', $client_id);
        $query = $this->db->get('client_payment');
        return $query->result();
    }
    // Livestock sale Payment
    function getSumClientAndSaleWiseTotalReceivedAmount($clientId, $purchaseId)
    {
        $this->db->select('SUM(cp_received_amount) AS total');
        $this->db->where('cp_c_id', $clientId);
        $this->db->where('cp_lsss_id', $purchaseId);
        $this->db->where('cp_status', 1);
        $query = $this->db->get('client_payment');
        return $query->row()->total;
    }
    // Product sale Payment
    function getSumClientAndProductSaleWiseTotalReceivedAmount($clientId, $purchaseId)
    {
        $this->db->select('SUM(cp_received_amount) AS total');
        $this->db->where('cp_c_id', $clientId);
        $this->db->where('cp_prss_id', $purchaseId);
        $this->db->where('cp_status', 1);
        $query = $this->db->get('client_payment');
        return $query->row()->total;
    }

    function getSumClientWiseTotalReceivedAndPaymentAmount($clientId, $column)
    {
        $this->db->select("SUM($column) AS total");
        $this->db->where('cp_c_id', $clientId);
        $this->db->where('cp_status', 1);
        $query = $this->db->get('client_payment');
        return $query->row()->total;
    }
    // Livestock Sale payment Count
    function getClientSaleWisePaymentCountRow($clientId, $lsss_id)
    {
        $count = $this->db->query("SELECT COUNT(cp_received_amount) AS total FROM client_payment WHERE cp_c_id = '$clientId' AND cp_lsss_id = '$lsss_id' AND cp_status = 1");
        return $count->row()->total;
    }
    // Product Sale payment Count
    function getClientProductSaleWisePaymentCountRow($clientId, $prss_id)
    {
        $count = $this->db->query("SELECT COUNT(cp_received_amount) AS total FROM client_payment WHERE cp_c_id = '$clientId' AND cp_prss_id = '$prss_id' AND cp_status = 1");
        return $count->row()->total;
    }

    function getSumClientTotalPaidAmount()
    {
        $this->db->select('SUM(cp_received_amount) AS total');
        $this->db->where('cp_status', 1);
        $query = $this->db->get('client_payment');
        return $query->row()->total;
    }


    /* =========================== Staff Part =========================== */

    function getStaffWisePayments($staff_id)
    {
        $this->db->where('sfp_status', 1);
        $this->db->where('sfp_sf_id', $staff_id);
        $query = $this->db->get('staff_payment');
        return $query->result();
    }


    function getStaffWiseTotalPaymentAndReceivedAmountSum($staff_id, $column)
    {
        $this->db->select("SUM($column) AS total");
        $this->db->where('sfp_sf_id', $staff_id);
        $this->db->where('sfp_status', 1);
        $query = $this->db->get('staff_payment');
        return $query->row()->total;
    }

    function getTotalStaffPaymentAmount($column)
    {
        $this->db->select("SUM($column) AS total");
        $this->db->where('sfp_status', 1);
        $query = $this->db->get('staff_payment');
        return $query->row()->total;
    }

    function getStaffWisePaymentAndReceivedCountRow($staff_id, $column)
    {
        $count = $this->db->query("SELECT COUNT($column) AS total FROM staff_payment WHERE sfp_sf_id = '$staff_id' AND sfp_status = 1");
        return $count->row()->total;
    }

    function getLastPaymentDate($staff_id, $column)
    {
        $count = $this->db->query("SELECT Max($column) AS total FROM staff_payment WHERE sfp_sf_id = '$staff_id' AND sfp_status = 1");
        return $count->row()->total;
    }







    // End
}
